function [s1,s2]=CornelisKerre(A,B)

N=200; % number of discretizations
minX=min(A(1),B(1)); % the range
maxX=max(A(4),B(4));
X=linspace(minX,maxX,N);

x1=mg(X,A(5:8),[0 A([9 9]) 0]);
x2=1-mg(X,A(1:4));
y1=mg(X,B(5:8),[0 B([9 9]) 0]);
y2=1-mg(X,B(1:4));

a=min(min(1,y1+1-x1),x2+1-y2);
b=max(0,y2+x1-1);
s1=sum(min([a;b],[],1))/N;
s2=sum(max([a;b],[],1))/N;

